import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../../util/processResponse.js";

const URL = `${BASE_API_URL_STG}/user/profile`;

const initialState = {
    userInfo: null,
    loading: false,
    isRefresh: false,
};

export const updateUserProfile = createAsyncThunk(
    "user/updateUserProfile",
    async (access_token) => {
        const userInfo = await queryResponse(URL, "GET", access_token);
        return userInfo;
    }
);

const updateUserProfileSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        fetchUpdateUserInfoStart: (state) => {
            state.isRefresh = true;
        },
        getUpdateUserInfo: (state) => {
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(updateUserProfile.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(updateUserProfile.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.userInfo = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(updateUserProfile.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { fetchUpdateUserInfoStart, getUpdateUserInfo } =
    updateUserProfileSlice.actions;

export default updateUserProfileSlice.reducer;
